#include "viewer.h"

/* These may one day break the PalmOS becuase these are 'technically'
   supposed to be reserved for licensees. We need to allocate a range
   so that we can properly catch toolbar events sitting on the silk
   screen. If the silkscreen breaks later, try changing these :)

   For more information, see Chars.h */
#define vchrPluckerMin             0x2000
#define vchrPluckerMax             0x200F

#define vchrPluckerDbase           ( vchrPluckerMin + LIBRARYCONTROL )
#define vchrPluckerOffset          ( vchrPluckerMin + OFFSETCONTROL )
#define vchrPluckerBookmark        ( vchrPluckerMin + BOOKMARKCONTROL )
#define vchrPluckerFind            ( vchrPluckerMin + FINDCONTROL )
#define vchrPluckerAgain           ( vchrPluckerMin + AGAINCONTROL )
#define vchrPluckerAutoscrollDecr  ( vchrPluckerMin + AUTOSCROLLDECRCONTROL )
#define vchrPluckerAutoscrollStop  ( vchrPluckerMin + AUTOSCROLLSTOPCONTROL )
#define vchrPluckerAutoscrollStart ( vchrPluckerMin + AUTOSCROLLSTARTCONTROL )
#define vchrPluckerAutoscrollIncr  ( vchrPluckerMin + AUTOSCROLLINCRCONTROL )
#define vchrPluckerLeft            ( vchrPluckerMin + LEFTCONTROL )
#define vchrPluckerHome            ( vchrPluckerMin + HOMECONTROL )
#define vchrPluckerRight           ( vchrPluckerMin + RIGHTCONTROL )

#ifdef HAVE_HANDERA_SDK
void HanderaSetSilkScreen( void ) HANDERA_SECTION;
void HanderaResetSilkScreen( void ) HANDERA_SECTION;
void HanderaUpdateSilkVerticalOffset(
                const Char* offText ) HANDERA_SECTION;
#else
#define HanderaSetSilkScreen()
#define HanderaResetSilkScreen()
#define HanderaUpdateSilkVerticalOffset(x)
#endif

